﻿/**
 * @fileoverview 浏览器布局
 * @author sunnyjiang
 * @version 1.1
 */

/**
 * @namespace layout
 */
var layout = {};

layout.pageBoxLeft = 0;
layout.pageBoxTop = 0;
layout.pageBoxRight = 0;
layout.pageBoxBottom = 0;

/**
 * resize layout when browser resize
 */
layout.resize = function() {
	var windowHeight = $(window).height();
	var windowWidth = $(window).width();	
	var pageBox = $('#page-box');
	var page = $('#page');
	var sidebar = $('#sidebar');
	
	var headHeight = 109;
//	var headWidth = $('#head-wrapper').width();

	// 设定页面显示区域高度
	var statuesBarHeight = $('#statusbar-box').outerHeight();
	var downloadbar = $('#downloadbar');
	var downloadBarHeight = downloadbar.is(':visible') ? downloadbar.outerHeight() + utils.fromPx2Int(downloadbar.css('margin-top')) : 0;

	var bodyBorderWidth = view.getBorderWidth($('body'));
	var mainElementBorderWidth = view.getBorderWidth('main');
	var pageBoxElementBorderWidth = view.getBorderWidth('page-box');
	
	var totalBorderWidth = bodyBorderWidth.top + bodyBorderWidth.bottom + // 计算其他元素的border
		mainElementBorderWidth.top + mainElementBorderWidth.bottom + 
		pageBoxElementBorderWidth.top + pageBoxElementBorderWidth.bottom;
	
//	debug([windowHeight, statuesBarHeight, headHeight, totalBorderWidth, downloadBarHeight]);
	var pageBoxHeight = windowHeight - statuesBarHeight - headHeight - totalBorderWidth - downloadBarHeight;
	$("#page-wrapper").height($("page").height()-downloadBarHeight);
	


	// 标签栏位置
	// tab bar right side
	layout.adjustTabBar();
	
	layout.adjustAddressInput();

	// 通知浏览器DIV大小改变
	var bodyBorderWidth = view.getBorderWidth($('body'));
	
	var pageBoxOffset = view.getInnerOffset('page-box');
	
	var pageBoxLeft = pageBoxOffset.left + bodyBorderWidth.left;
	var pageBoxTop = pageBoxOffset.top + bodyBorderWidth.top;
	var pageBoxWidth = page.width();
	var pageBoxHeight = page.height();
	var pageBoxRight = windowWidth - pageBoxWidth - pageBoxLeft;
	var pageBoxBottom = windowHeight - pageBoxHeight - pageBoxTop;
	
	var tabInner = $('#tab-inner');
	var tabInnerLeft = tabInner.offset().left;
	var tabInnerTop = tabInner.offset().top;
	var tabInnerWidth = tabInner.width();
	var tabInnerHeight = tabInner.height();
	
//	debug([tabInnerLeft, tabInnerTop, tabInnerWidth, tabInnerHeight]);
	try{
		qqbrowser.log.info("pageBoxleft: "+ pageBoxleft);
		qqbrowser.log.info("pageBoxleft: "+ pageBoxTop);
	}catch(err){
	}
	
	if (!(pageBoxLeft === layout.pageBoxLeft 
			&& pageBoxTop === layout.pageBoxTop
			&& pageBoxRight === layout.pageBoxRight
			&& pageBoxBottom === layout.pageBoxBottom) ) {
		layout.pageBoxLeft = pageBoxLeft;
		layout.pageBoxTop = pageBoxTop;
		layout.pageBoxRight = pageBoxRight;
		layout.pageBoxBottom = pageBoxBottom;
		
		browser.skin.resize([[1, 0, pageBoxLeft, pageBoxTop, pageBoxWidth, pageBoxHeight], [3, 0, tabInnerLeft, tabInnerTop, tabInnerWidth, tabInnerHeight]]);
	} else {
		browser.skin.resize([[3, 0, tabInnerLeft, tabInnerTop, tabInnerWidth, tabInnerHeight]]);
	}
	
};

//侧边栏缩放，皮肤窗口调整，不调整tab栏、地址栏
layout.siderbarResize = function() {

	var windowHeight = $(window).height();
	var windowWidth = $(window).width();	
	var pageBox = $('#page-box');
	var page = $('#page');
	var sidebar = $('#sidebar');
	
	var headHeight = 109;

	// 设定页面显示区域高度
	var statuesBarHeight = $('#statusbar-box').outerHeight();
	var downloadbar = $('#downloadbar');
	var downloadBarHeight = downloadbar.is(':visible') ? downloadbar.outerHeight() + utils.fromPx2Int(downloadbar.css('margin-top')) : 0;

	var bodyBorderWidth = view.getBorderWidth($('body'));
	var mainElementBorderWidth = view.getBorderWidth('main');
	var pageBoxElementBorderWidth = view.getBorderWidth('page-box');
	
	var totalBorderWidth = bodyBorderWidth.top + bodyBorderWidth.bottom + // 计算其他元素的border
		mainElementBorderWidth.top + mainElementBorderWidth.bottom + 
		pageBoxElementBorderWidth.top + pageBoxElementBorderWidth.bottom;
	
	var pageBoxHeight = windowHeight - statuesBarHeight - headHeight - totalBorderWidth - downloadBarHeight;
//	pageBox.height(pageBoxHeight);


	// 通知浏览器DIV大小改变
	var bodyBorderWidth = view.getBorderWidth($('body'));
	
	var pageBoxOffset = view.getInnerOffset('page-box');
	
	var pageBoxLeft = pageBoxOffset.left + bodyBorderWidth.left;
	var pageBoxTop = pageBoxOffset.top + bodyBorderWidth.top;
	var pageBoxWidth = page.width();
	var pageBoxHeight = page.height();
	
	var tabInner = $('#tab-inner');
	var tabInnerLeft = tabInner.offset().left;
	var tabInnerTop = tabInner.offset().top;
	var tabInnerWidth = tabInner.width();
	var tabInnerHeight = tabInner.height();
	
	browser.skin.resize([[1, 0, pageBoxLeft, pageBoxTop, pageBoxWidth, pageBoxHeight], [3, 0, tabInnerLeft, tabInnerTop, tabInnerWidth, tabInnerHeight]]);	
};

/**
 * 设定地址栏输入框位置
 */
layout.adjustAddressInput = function() {
	var windowWidth = $(window).width();
	
	// addressbar距离左边的距离，根据几个条件组合计算
	// 根据$('#addressbar-box').offset().left来判断在窗口大小变化时会有问题
	var addressbarLeft = $('#toolbar-left-box').offset().left + $('#toolbar-left-box').width() 
		+ utils.fromPx2Int($('#addressbar-box').css('margin-left'));	
//	$('#address-input').width(200); // 将address-input设置为较小的值，使得toolbar-right-box的位置回到原位
	var rightButtonBoxRight = windowWidth - $('#toolbar-right-box').offset().left; // right button box距离右边的距离	

	var addressbarButtonWidth = $('#addressbar-box').width() - $('#address-input').width(); // addressbar中按钮的宽度	
	var noAddressInputWidth = addressbarLeft + rightButtonBoxRight + addressbarButtonWidth;
//	debug([$('#addressbar-box').width(), $('#address-input').width()]);
	
//	$('#address-input').width(windowWidth - noAddressInputWidth);
};

/**
 * resize时调整tab的显示宽度
 */
layout.adjustTabBar = function() {
	var windowWidth = $(window).width();
	
	var newTabButton = $('#new-tab-button');
	var closeButtonWidth = $('#tabset div.tab-close').outerWidth();
	var tabInner = $('#tab-inner');
	
	// 计算除tab外宽度
//	var tabsLeft = $('#tabset').offset().left;
//	var headRightButtonBoxWidth = windowWidth - $('#feedback-button').offset().left;
	var newTabButtonWidth = newTabButton.outerWidth() + utils.fromPx2Int(newTabButton.css('margin-left'));

//	var otherWidth = $('#tab-wrapper-right').offset().left; // 除去tabs外的宽度
	
//	var minTabWidth = utils.fromPx2Int($('.mbTab', tabInner).css('min-width'));
	var maxTabWidth = utils.fromPx2Int($('.mbTab', tabInner).css('max-width'));
	
//	var hideCloseButtonTabWidth = 80; // 当tab宽度小于多少时隐藏close按钮
	var noTitleTabWidth = 40; // 当tab宽度小于多少时隐藏标题
	var titleLastWidth = 50; // 用于计算title的宽度
//	var minTabWidth = 19;
	
	var titleClipWidth = 73;
	var noCloseButtonWidth = 52; // 当tab宽度小于多少时隐藏关闭按钮
	var noIconWidth = 20; // 当tab宽度小于多少时隐藏icon

	var tabsWidth = 0;
	var tabs = tabManager.getTabs();
	var tabsCount = tabs.length;
	tabs.each( function() { // 计算出当前tabs总宽度
		tabsWidth += $(this).width();
	});
	
//	alert($('#tab-wrapper-right').offset().left);
	var tabsInnerWidth = $('#tab-wrapper-right').offset().left - $('#logo-menu').width(); // tab栏总共可以显示的宽度
	var tabsViewWidth = tabsInnerWidth - newTabButtonWidth; // tabs总宽度为tabsInnerWidth减去new tab button宽度
	var showTabsCount = tabsCount; // 要显示的tab个数

	// 如果tab总宽度大于显示面积，或者tab宽度比最大宽度小时，调整大小	
	if(tabsWidth > tabsViewWidth || tabsWidth / tabsCount <= maxTabWidth) {
		var tabTitles = $('#tabset .tab .title');
		var newTabTitles = $('#tabset .tab.new .title');	
		var tabIcons = $('#tabset .tab img');
		var newTabIcons = $('#tabset .tab.new img');		
		var closeTabButtons = $('#tabset div:not(.sel) .tab-close');
		var currentTab = $('#tabset div.sel');
		
//		debug(tabManager.getMarginLeft());
		// 要算上tab的margin-left才能算出tab的真实宽度
		var tabsSpaceWidth = tabsViewWidth - tabManager.getMarginLeft() * (tabsCount - 1);
		
		// 计算每个tab可以显示的宽度
		var tabWidth = Math.floor(tabsSpaceWidth / tabsCount);
				
		// 小于最小宽度时，处理逻辑为后面的tab不显示，出现页面缩略列表
/*		if(tabWidth < minTabWidth) {
			// TODO 如果最后一个选中，不缩略此项
			
			// 计算应该隐藏多少个
			var hideTabsCount = Math.ceil((minTabWidth * tabsCount - tabsViewWidth) / minTabWidth); 
			showTabsCount = tabsCount - hideTabsCount;
			
			tabsSpaceWidth = tabsViewWidth - tabManager.getMarginLeft() * (showTabsCount - 1);
			// 重新计算宽度
			tabWidth = Math.floor(tabsSpaceWidth / showTabsCount);
		} */
		
		// 显示宽度不能大于maxTabWidth
		if(tabWidth > maxTabWidth)
			tabWidth = maxTabWidth;
		
		// 关闭按钮隐藏逻辑
		if(tabWidth < noCloseButtonWidth) {
			closeTabButtons.hide();
		} else {
			closeTabButtons.show();
		}
		
	
		// 控制title截取显示
		if(tabWidth <= titleClipWidth) {
			tabTitles.css('text-overflow', 'clip');
		} else {
			tabTitles.css('text-overflow', 'ellipsis');
		}
		
		// 控制title宽度，隐藏close button时title变长
		if(tabWidth < noCloseButtonWidth) {
			titleLastWidth -= closeButtonWidth;
		}
						
		// title隐藏逻辑
		if(tabWidth < noTitleTabWidth) {
			tabTitles.hide();	
		} else {
			tabTitles.show();		
		}
		
		// icons隐藏逻辑
		if(tabWidth <= noIconWidth) {
			tabIcons.hide();
		} else {
			tabIcons.show();
		}
		
		qqbrowser.log.info("ningzhangx:tabWidth:" + tabWidth);
		// hard code
		// 调整极值下icon的位置
		if(tabWidth <= 22) {
			tabIcons.css('margin-left', '1px');	
			newTabIcons.css('margin-left', '3px');
		}  else if(tabWidth <= 25) {
			tabIcons.css('margin-left', '2px');	
			newTabIcons.css('margin-left', '4px');			
		} else if(tabWidth <= 29) {
			tabIcons.css('margin-left', '4px');	
			newTabIcons.css('margin-left', '7px');
		} else {
			tabIcons.css('margin-left', '');	
			newTabIcons.css('margin-left', '10px');
		}
		
		// current tab 
		if(tabWidth <= 52 && tabWidth > 40) {
			$('.title', currentTab).hide();
			$('img', currentTab).show();
			$('.tab-close', currentTab).show();	
		} else if(tabWidth <= 40) {
			$('.title', currentTab).hide();
			$('img', currentTab).hide();	
			$('.tab-close', currentTab).show();
		} else {
			$('.title', currentTab).show();
			$('img', currentTab).show();	
			$('.tab-close', currentTab).show();					
		}		
		
		var tabIndex = 1;
		var lastPx = tabWidth == maxTabWidth ? 0 : tabsSpaceWidth - showTabsCount * tabWidth; // 剩余多少px, 最大长度时为0

//		$('#page-box').html(tabsInnerWidth + '-' + tabsViewWidth + '-' + showTabsCount + '-' + tabWidth + '-' + lastPx);
		tabs.each( function() {
			var tabSetWidth = lastPx > 0 ? tabWidth + 1 : tabWidth; // last px有剩时分配在前面的tab上
			
			$(this).show();
			
			// 隐藏多余的tab
			if(tabIndex++ > showTabsCount) {
//				if(!$(this).is('.sel')) { // TODO 选中的不隐藏
					$(this).hide();
//				} else {
//					tabIndex--;
//				}
			} else {
				$(this).width(tabSetWidth);
				$(this).css("background-position-x", tabSetWidth - 6); // 调整背景图片位置，对应tab右边图片
				$(this).children('span').width(tabSetWidth - 10);	// 调整span宽度，对应tab左边图片
			}
			lastPx--;
		});	
		
		if(tabWidth == maxTabWidth)
			tabsViewWidth = tabWidth * showTabsCount;
			
		if(tabWidth <= maxTabWidth) { // 固定inner的大小
			tabInner.width(tabsInnerWidth);
//			var newTabButtonMarginLeft = tabsInnerWidth - $('#tabset').width() - 28; // 28是空白宽度
//			if(newTabButtonMarginLeft >= 0) {
//				newTabButton.css('margin-left', newTabButtonMarginLeft);
//			}
		}
		
		tabTitles.width(tabWidth - titleLastWidth); // 标题的宽度为tab宽度减noTitleTabWidth
		newTabTitles.width(tabWidth - titleLastWidth - 6); // 6是new下favicon和普通tab margin-left之差

//		tabTitles.css('-webkit-mask-image', '-webkit-gradient(linear, 100% 0%, ' + (tabTitles.width() - 15)  + ' 0, from(transparent), to(black))');
		
/* 此部分逻辑去掉
		if(tabWidth <= noTitleTabWidth)
			tabTitles.hide();
		else
			tabTitles.show(); */
		
		// hover时背景的调整
		tabs.hover( 
			function() { // hover up				
				if(!$(this).is('.sel') && !$(this).is('.tab-close')) {
					$(this).addClass('tab-hover').css('z-index', 19);
				}
			},
			function() { // hover out
				if(!$(this).is('.sel') && !$(this).is('.tab-close')) {
					$(this).removeClass('tab-hover').css('z-index', 10);;
				}
			}
		);
	} 
//	else {
//		tabInner.width(tabsCount * maxTabWidth + newTabButtonWidth); // 固定tab-wrapper宽度，防止new-button和tabset间距变化
//		newTabButton.css('margin-left', 0);
//	}
};

/**
 * 调整地址栏下拉列表的显示
 */
layout.adjustAddressList = function() {
	var addressInput = $('#address');
	
	var addressListLeft = addressInput.offset().left;
	var addressListTop = addressInput.offset().top + addressInput.outerHeight() - 1; // 与地址栏输入框下border重合
	var addressListWidth = $('#address-list-right').offset().left - $('#address-list-left').offset().left; // 25为address list button宽度 

	$('#address-list').css('left', addressListLeft).css('top', addressListTop).width(addressListWidth);
};

/**
 * 获得页面的最小大小
 */
layout.getMinSize = function() {
	var minWidth = utils.fromPx2Int($(document.body).css('min-width'));
	var minHeight = utils.fromPx2Int($(document.body).css('min-height'));
	
	return { width: minWidth, height: minHeight};
};
